# Player: huggingface_DeepSeek-V3-0324_PayoffMaximizer_A (as Player A)
# Meta-Round: 4
# Experiment: PMxPM, Run: 4
# API: huggingface, Model: deepseek-ai/DeepSeek-V3-0324
# Based on textual strategy: huggingface_DeepSeek_V3_0324_PayoffMaximizer_A_MR4_strategy.txt
# LLM Suggested Fallback: C

def huggingface_DeepSeek_V3_0324_PayoffMaximizer_A_MR4(my_history: list, opp_history: list, opponent_program_code: str) -> str:
    current_round = len(my_history) + 1
    
    # Round 1: Cooperate
    if current_round == 1:
        return "C"
    
    # Initial Phase (Rounds 2-3): Tit-for-Tat with 10% chance to defect unprovoked
    if 2 <= current_round <= 3:
        if random.random() < 0.1:
            return "D"
        else:
            return opp_history[-1]
    
    # Middle Phase (Rounds 4-7)
    if 4 <= current_round <= 7:
        # Count opponent's defections in first 3 rounds
        early_defects = opp_history[:3].count("D")
        if early_defects >= 2:
            return "D"
        else:
            if opp_history[-1] == "C":
                return "D" if random.random() < 0.2 else "C"
            else:
                return "D" if random.random() < 0.9 else "C"
    
    # Late Phase (Rounds 8-10)
    if current_round >= 8:
        total_defects = opp_history.count("D")
        if total_defects >= 4:
            return "D"
        else:
            return "C" if current_round % 2 == 0 else "D"
    
    # Default fallback (should not be reached)
    return "C"